/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.finallion.graveyard.config.BiomeConfig;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GraveyardConfig {
    public static final CommonConfig COMMON_CONFIG;
    public static ForgeConfigSpec COMMON_SPEC;
    public static final GraveyardConfig INSTANCE;
    public static final List<BiomeConfig> BIOMES;
    private static final BiomeConfig.Builder config;
    public static final BiomeConfig HAUNTED_FOREST;
    public static final BiomeConfig HAUNTED_LAKES;
    public static final BiomeConfig ERODED_HAUNTED_FOREST;
    public boolean ENABLE_HAUNTED_FOREST_FOG;
    public boolean ENABLE_HAUNTED_LAKES_FOG;
    public boolean ENABLE_ERODED_HAUNTED_FOREST_FOG;
    public boolean ENABLE_GRAVEYARD_FOG;
    public boolean ENABLE_BIRCH_TREE;
    public boolean ENABLE_MEDIUM_GRAVEYARD;
    public boolean ENABLE_LARGE_GRAVEYARD;
    public boolean ENABLE_SMALL_GRAVEYARD;
    public boolean ENABLE_SMALL_GRAVEYARD_DESERT;
    public boolean ENABLE_SMALL_GRAVEYARD_SAVANNA;
    public boolean ENABLE_MUSHROOM_GRAVE;
    public boolean ENABLE_GRAVE;
    public boolean ENABLE_HAUNTED_HOUSE;
    public boolean ENABLE_DESERT_GRAVE;
    public boolean ENABLE_SAVANNA_GRAVE;
    public boolean ENABLE_MOUNTAIN_GRAVE;
    public int BIRCH_TREE_SEPARATION;
    public int MEDIUM_GRAVEYARD_SEPARATION;
    public int LARGE_GRAVEYARD_SEPARATION;
    public int SMALL_GRAVEYARD_SEPARATION;
    public int SMALL_GRAVEYARD_DESERT_SEPARATION;
    public int SMALL_GRAVEYARD_SAVANNA_SEPARATION;
    public int MUSHROOM_GRAVE_SEPARATION;
    public int GRAVE_SEPARATION;
    public int HAUNTED_HOUSE_SEPARATION;
    public int DESERT_GRAVE_SEPARATION;
    public int SAVANNA_GRAVE_SEPARATION;
    public int MOUNTAIN_GRAVE_SEPARATION;
    public int BIRCH_TREE_SPACING;
    public int MEDIUM_GRAVEYARD_SPACING;
    public int LARGE_GRAVEYARD_SPACING;
    public int SMALL_GRAVEYARD_SPACING;
    public int SMALL_GRAVEYARD_DESERT_SPACING;
    public int SMALL_GRAVEYARD_SAVANNA_SPACING;
    public int MUSHROOM_GRAVE_SPACING;
    public int GRAVE_SPACING;
    public int HAUNTED_HOUSE_SPACING;
    public int DESERT_GRAVE_SPACING;
    public int SAVANNA_GRAVE_SPACING;
    public int MOUNTAIN_GRAVE_SPACING;
    public int BIRCH_TREE_SALT;
    public int MEDIUM_GRAVEYARD_SALT;
    public int LARGE_GRAVEYARD_SALT;
    public int SMALL_GRAVEYARD_SALT;
    public int SMALL_GRAVEYARD_DESERT_SALT;
    public int SMALL_GRAVEYARD_SAVANNA_SALT;
    public int MUSHROOM_GRAVE_SALT;
    public int GRAVE_SALT;
    public int HAUNTED_HOUSE_SALT;
    public int DESERT_GRAVE_SALT;
    public int SAVANNA_GRAVE_SALT;
    public int MOUNTAIN_GRAVE_SALT;
    public int HAUNTED_FOREST_FOG_MAXY;
    public int HAUNTED_LAKES_FOG_MAXY;
    public int ERODED_HAUNTED_FOREST_FOG_MAXY;
    public int HAUNTED_FOREST_FOG_MINY;
    public int HAUNTED_LAKES_FOG_MINY;
    public int ERODED_HAUNTED_FOREST_FOG_MINY;
    public int FOG_CHANCE;
    public double HAUNTED_FOREST_FOG_DENSITY;
    public double HAUNTED_LAKES_FOG_DENSITY;
    public double ERODED_HAUNTED_FOREST_FOG_DENSITY;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent e) {
        if (e.getConfig().getSpec() == COMMON_SPEC) {
            GraveyardConfig.bakeCommonConfig();
        }
    }

    private static void bakeCommonConfig() {
        GraveyardConfig.INSTANCE.ENABLE_HAUNTED_FOREST_FOG = (Boolean)GraveyardConfig.COMMON_CONFIG.haunted_forest_fog.get();
        GraveyardConfig.INSTANCE.ENABLE_HAUNTED_LAKES_FOG = (Boolean)GraveyardConfig.COMMON_CONFIG.haunted_lakes_fog.get();
        GraveyardConfig.INSTANCE.ENABLE_ERODED_HAUNTED_FOREST_FOG = (Boolean)GraveyardConfig.COMMON_CONFIG.eroded_haunted_forest_fog.get();
        GraveyardConfig.INSTANCE.ENABLE_GRAVEYARD_FOG = (Boolean)GraveyardConfig.COMMON_CONFIG.fog_particle.get();
        GraveyardConfig.INSTANCE.HAUNTED_FOREST_FOG_MAXY = (Integer)GraveyardConfig.COMMON_CONFIG.haunted_forest_fogMaxY.get();
        GraveyardConfig.INSTANCE.HAUNTED_LAKES_FOG_MAXY = (Integer)GraveyardConfig.COMMON_CONFIG.haunted_lakes_fogMaxY.get();
        GraveyardConfig.INSTANCE.ERODED_HAUNTED_FOREST_FOG_MAXY = (Integer)GraveyardConfig.COMMON_CONFIG.eroded_haunted_forest_fogMaxY.get();
        GraveyardConfig.INSTANCE.HAUNTED_FOREST_FOG_MINY = (Integer)GraveyardConfig.COMMON_CONFIG.haunted_forest_fogMinY.get();
        GraveyardConfig.INSTANCE.HAUNTED_LAKES_FOG_MINY = (Integer)GraveyardConfig.COMMON_CONFIG.haunted_lakes_fogMinY.get();
        GraveyardConfig.INSTANCE.ERODED_HAUNTED_FOREST_FOG_MINY = (Integer)GraveyardConfig.COMMON_CONFIG.eroded_haunted_forest_fogMinY.get();
        GraveyardConfig.INSTANCE.HAUNTED_FOREST_FOG_DENSITY = (Double)GraveyardConfig.COMMON_CONFIG.haunted_forest_fog_density.get();
        GraveyardConfig.INSTANCE.HAUNTED_LAKES_FOG_DENSITY = (Double)GraveyardConfig.COMMON_CONFIG.haunted_lakes_fog_density.get();
        GraveyardConfig.INSTANCE.ERODED_HAUNTED_FOREST_FOG_DENSITY = (Double)GraveyardConfig.COMMON_CONFIG.eroded_haunted_forest_fog_density.get();
        GraveyardConfig.INSTANCE.FOG_CHANCE = (Integer)GraveyardConfig.COMMON_CONFIG.fog_particle_chance.get();
        GraveyardConfig.INSTANCE.ENABLE_BIRCH_TREE = (Boolean)GraveyardConfig.COMMON_CONFIG.large_birch_tree.get();
        GraveyardConfig.INSTANCE.BIRCH_TREE_SEPARATION = (Integer)GraveyardConfig.COMMON_CONFIG.large_birch_tree_separation.get();
        GraveyardConfig.INSTANCE.BIRCH_TREE_SPACING = (Integer)GraveyardConfig.COMMON_CONFIG.large_birch_tree_spacing.get();
        GraveyardConfig.INSTANCE.BIRCH_TREE_SALT = (Integer)GraveyardConfig.COMMON_CONFIG.large_birch_tree_salt.get();
        GraveyardConfig.INSTANCE.ENABLE_MEDIUM_GRAVEYARD = (Boolean)GraveyardConfig.COMMON_CONFIG.medium_walled_graveyard.get();
        GraveyardConfig.INSTANCE.MEDIUM_GRAVEYARD_SEPARATION = (Integer)GraveyardConfig.COMMON_CONFIG.medium_walled_graveyard_separation.get();
        GraveyardConfig.INSTANCE.MEDIUM_GRAVEYARD_SPACING = (Integer)GraveyardConfig.COMMON_CONFIG.medium_walled_graveyard_spacing.get();
        GraveyardConfig.INSTANCE.MEDIUM_GRAVEYARD_SALT = (Integer)GraveyardConfig.COMMON_CONFIG.medium_walled_graveyard_salt.get();
        GraveyardConfig.INSTANCE.ENABLE_LARGE_GRAVEYARD = (Boolean)GraveyardConfig.COMMON_CONFIG.large_walled_graveyard.get();
        GraveyardConfig.INSTANCE.LARGE_GRAVEYARD_SEPARATION = (Integer)GraveyardConfig.COMMON_CONFIG.large_walled_graveyard_separation.get();
        GraveyardConfig.INSTANCE.LARGE_GRAVEYARD_SPACING = (Integer)GraveyardConfig.COMMON_CONFIG.large_walled_graveyard_spacing.get();
        GraveyardConfig.INSTANCE.LARGE_GRAVEYARD_SALT = (Integer)GraveyardConfig.COMMON_CONFIG.large_walled_graveyard_salt.get();
        GraveyardConfig.INSTANCE.ENABLE_SMALL_GRAVEYARD = (Boolean)GraveyardConfig.COMMON_CONFIG.small_walled_graveyard.get();
        GraveyardConfig.INSTANCE.SMALL_GRAVEYARD_SEPARATION = (Integer)GraveyardConfig.COMMON_CONFIG.small_walled_graveyard_separation.get();
        GraveyardConfig.INSTANCE.SMALL_GRAVEYARD_SPACING = (Integer)GraveyardConfig.COMMON_CONFIG.small_walled_graveyard_spacing.get();
        GraveyardConfig.INSTANCE.SMALL_GRAVEYARD_SALT = (Integer)GraveyardConfig.COMMON_CONFIG.small_walled_graveyard_salt.get();
        GraveyardConfig.INSTANCE.ENABLE_SMALL_GRAVEYARD_DESERT = (Boolean)GraveyardConfig.COMMON_CONFIG.small_walled_graveyard_desert.get();
        GraveyardConfig.INSTANCE.SMALL_GRAVEYARD_DESERT_SEPARATION = (Integer)GraveyardConfig.COMMON_CONFIG.small_walled_graveyard_desert_separation.get();
        GraveyardConfig.INSTANCE.SMALL_GRAVEYARD_DESERT_SPACING = (Integer)GraveyardConfig.COMMON_CONFIG.small_walled_graveyard_desert_spacing.get();
        GraveyardConfig.INSTANCE.SMALL_GRAVEYARD_DESERT_SALT = (Integer)GraveyardConfig.COMMON_CONFIG.small_walled_graveyard_desert_salt.get();
        GraveyardConfig.INSTANCE.ENABLE_SMALL_GRAVEYARD_SAVANNA = (Boolean)GraveyardConfig.COMMON_CONFIG.small_walled_graveyard_savanna.get();
        GraveyardConfig.INSTANCE.SMALL_GRAVEYARD_SAVANNA_SEPARATION = (Integer)GraveyardConfig.COMMON_CONFIG.small_walled_graveyard_savanna_separation.get();
        GraveyardConfig.INSTANCE.SMALL_GRAVEYARD_SAVANNA_SPACING = (Integer)GraveyardConfig.COMMON_CONFIG.small_walled_graveyard_savanna_spacing.get();
        GraveyardConfig.INSTANCE.SMALL_GRAVEYARD_SAVANNA_SALT = (Integer)GraveyardConfig.COMMON_CONFIG.small_walled_graveyard_savanna_salt.get();
        GraveyardConfig.INSTANCE.ENABLE_GRAVE = (Boolean)GraveyardConfig.COMMON_CONFIG.small_grave.get();
        GraveyardConfig.INSTANCE.GRAVE_SEPARATION = (Integer)GraveyardConfig.COMMON_CONFIG.small_grave_separation.get();
        GraveyardConfig.INSTANCE.GRAVE_SPACING = (Integer)GraveyardConfig.COMMON_CONFIG.small_grave_spacing.get();
        GraveyardConfig.INSTANCE.GRAVE_SALT = (Integer)GraveyardConfig.COMMON_CONFIG.small_grave_salt.get();
        GraveyardConfig.INSTANCE.ENABLE_DESERT_GRAVE = (Boolean)GraveyardConfig.COMMON_CONFIG.small_desert_grave.get();
        GraveyardConfig.INSTANCE.DESERT_GRAVE_SEPARATION = (Integer)GraveyardConfig.COMMON_CONFIG.small_desert_grave_separation.get();
        GraveyardConfig.INSTANCE.DESERT_GRAVE_SPACING = (Integer)GraveyardConfig.COMMON_CONFIG.small_desert_grave_spacing.get();
        GraveyardConfig.INSTANCE.DESERT_GRAVE_SALT = (Integer)GraveyardConfig.COMMON_CONFIG.small_desert_grave_salt.get();
        GraveyardConfig.INSTANCE.ENABLE_SAVANNA_GRAVE = (Boolean)GraveyardConfig.COMMON_CONFIG.small_savanna_grave.get();
        GraveyardConfig.INSTANCE.SAVANNA_GRAVE_SEPARATION = (Integer)GraveyardConfig.COMMON_CONFIG.small_savanna_grave_separation.get();
        GraveyardConfig.INSTANCE.SAVANNA_GRAVE_SPACING = (Integer)GraveyardConfig.COMMON_CONFIG.small_savanna_grave_spacing.get();
        GraveyardConfig.INSTANCE.SAVANNA_GRAVE_SALT = (Integer)GraveyardConfig.COMMON_CONFIG.small_savanna_grave_salt.get();
        GraveyardConfig.INSTANCE.ENABLE_MOUNTAIN_GRAVE = (Boolean)GraveyardConfig.COMMON_CONFIG.small_mountain_grave.get();
        GraveyardConfig.INSTANCE.MOUNTAIN_GRAVE_SEPARATION = (Integer)GraveyardConfig.COMMON_CONFIG.small_mountain_grave_separation.get();
        GraveyardConfig.INSTANCE.MOUNTAIN_GRAVE_SPACING = (Integer)GraveyardConfig.COMMON_CONFIG.small_mountain_grave_spacing.get();
        GraveyardConfig.INSTANCE.MOUNTAIN_GRAVE_SALT = (Integer)GraveyardConfig.COMMON_CONFIG.small_mountain_grave_salt.get();
        GraveyardConfig.INSTANCE.ENABLE_MUSHROOM_GRAVE = (Boolean)GraveyardConfig.COMMON_CONFIG.mushroom_grave.get();
        GraveyardConfig.INSTANCE.MUSHROOM_GRAVE_SEPARATION = (Integer)GraveyardConfig.COMMON_CONFIG.mushroom_grave_separation.get();
        GraveyardConfig.INSTANCE.MUSHROOM_GRAVE_SPACING = (Integer)GraveyardConfig.COMMON_CONFIG.mushroom_grave_spacing.get();
        GraveyardConfig.INSTANCE.MUSHROOM_GRAVE_SALT = (Integer)GraveyardConfig.COMMON_CONFIG.mushroom_grave_salt.get();
        GraveyardConfig.INSTANCE.ENABLE_HAUNTED_HOUSE = (Boolean)GraveyardConfig.COMMON_CONFIG.haunted_house.get();
        GraveyardConfig.INSTANCE.HAUNTED_HOUSE_SEPARATION = (Integer)GraveyardConfig.COMMON_CONFIG.haunted_house_separation.get();
        GraveyardConfig.INSTANCE.HAUNTED_HOUSE_SPACING = (Integer)GraveyardConfig.COMMON_CONFIG.haunted_house_spacing.get();
        GraveyardConfig.INSTANCE.HAUNTED_HOUSE_SALT = (Integer)GraveyardConfig.COMMON_CONFIG.haunted_house_salt.get();
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    static {
        INSTANCE = new GraveyardConfig();
        BIOMES = new ArrayList<BiomeConfig>();
        config = new BiomeConfig.Builder(BIOMES);
        HAUNTED_FOREST = config.build("haunted_forest", 3);
        HAUNTED_LAKES = config.build("haunted_lakes", 3);
        ERODED_HAUNTED_FOREST = config.build("eroded_haunted_forest", 2);
        Pair COMMON_PAIR = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_CONFIG = (CommonConfig)COMMON_PAIR.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)COMMON_PAIR.getRight();
    }

    public static class CommonConfig {
        public ForgeConfigSpec.BooleanValue large_birch_tree;
        public ForgeConfigSpec.BooleanValue medium_walled_graveyard;
        public ForgeConfigSpec.BooleanValue small_walled_graveyard;
        public ForgeConfigSpec.BooleanValue small_walled_graveyard_desert;
        public ForgeConfigSpec.BooleanValue small_walled_graveyard_savanna;
        public ForgeConfigSpec.BooleanValue large_walled_graveyard;
        public ForgeConfigSpec.BooleanValue haunted_house;
        public ForgeConfigSpec.BooleanValue small_grave;
        public ForgeConfigSpec.BooleanValue mushroom_grave;
        public ForgeConfigSpec.BooleanValue small_desert_grave;
        public ForgeConfigSpec.BooleanValue small_savanna_grave;
        public ForgeConfigSpec.BooleanValue small_mountain_grave;
        public ForgeConfigSpec.BooleanValue fog_particle;
        public ForgeConfigSpec.BooleanValue haunted_forest_fog;
        public ForgeConfigSpec.BooleanValue haunted_lakes_fog;
        public ForgeConfigSpec.BooleanValue eroded_haunted_forest_fog;
        public ForgeConfigSpec.ConfigValue<Integer> large_birch_tree_separation;
        public ForgeConfigSpec.ConfigValue<Integer> large_birch_tree_spacing;
        public ForgeConfigSpec.ConfigValue<Integer> large_birch_tree_salt;
        public ForgeConfigSpec.ConfigValue<Integer> medium_walled_graveyard_separation;
        public ForgeConfigSpec.ConfigValue<Integer> medium_walled_graveyard_spacing;
        public ForgeConfigSpec.ConfigValue<Integer> medium_walled_graveyard_salt;
        public ForgeConfigSpec.ConfigValue<Integer> small_walled_graveyard_separation;
        public ForgeConfigSpec.ConfigValue<Integer> small_walled_graveyard_spacing;
        public ForgeConfigSpec.ConfigValue<Integer> small_walled_graveyard_salt;
        public ForgeConfigSpec.ConfigValue<Integer> small_walled_graveyard_desert_separation;
        public ForgeConfigSpec.ConfigValue<Integer> small_walled_graveyard_desert_spacing;
        public ForgeConfigSpec.ConfigValue<Integer> small_walled_graveyard_desert_salt;
        public ForgeConfigSpec.ConfigValue<Integer> small_walled_graveyard_savanna_separation;
        public ForgeConfigSpec.ConfigValue<Integer> small_walled_graveyard_savanna_spacing;
        public ForgeConfigSpec.ConfigValue<Integer> small_walled_graveyard_savanna_salt;
        public ForgeConfigSpec.ConfigValue<Integer> large_walled_graveyard_separation;
        public ForgeConfigSpec.ConfigValue<Integer> large_walled_graveyard_spacing;
        public ForgeConfigSpec.ConfigValue<Integer> large_walled_graveyard_salt;
        public ForgeConfigSpec.ConfigValue<Integer> haunted_house_separation;
        public ForgeConfigSpec.ConfigValue<Integer> haunted_house_spacing;
        public ForgeConfigSpec.ConfigValue<Integer> haunted_house_salt;
        public ForgeConfigSpec.ConfigValue<Integer> small_grave_separation;
        public ForgeConfigSpec.ConfigValue<Integer> small_grave_spacing;
        public ForgeConfigSpec.ConfigValue<Integer> small_grave_salt;
        public ForgeConfigSpec.ConfigValue<Integer> small_desert_grave_separation;
        public ForgeConfigSpec.ConfigValue<Integer> small_desert_grave_spacing;
        public ForgeConfigSpec.ConfigValue<Integer> small_desert_grave_salt;
        public ForgeConfigSpec.ConfigValue<Integer> small_savanna_grave_separation;
        public ForgeConfigSpec.ConfigValue<Integer> small_savanna_grave_spacing;
        public ForgeConfigSpec.ConfigValue<Integer> small_savanna_grave_salt;
        public ForgeConfigSpec.ConfigValue<Integer> small_mountain_grave_separation;
        public ForgeConfigSpec.ConfigValue<Integer> small_mountain_grave_spacing;
        public ForgeConfigSpec.ConfigValue<Integer> small_mountain_grave_salt;
        public ForgeConfigSpec.ConfigValue<Integer> mushroom_grave_separation;
        public ForgeConfigSpec.ConfigValue<Integer> mushroom_grave_spacing;
        public ForgeConfigSpec.ConfigValue<Integer> mushroom_grave_salt;
        public ForgeConfigSpec.ConfigValue<Integer> fog_particle_chance;
        public ForgeConfigSpec.ConfigValue<Integer> haunted_forest_fogMaxY;
        public ForgeConfigSpec.ConfigValue<Integer> haunted_forest_fogMinY;
        public ForgeConfigSpec.ConfigValue<Integer> haunted_lakes_fogMaxY;
        public ForgeConfigSpec.ConfigValue<Integer> haunted_lakes_fogMinY;
        public ForgeConfigSpec.ConfigValue<Integer> eroded_haunted_forest_fogMaxY;
        public ForgeConfigSpec.ConfigValue<Integer> eroded_haunted_forest_fogMinY;
        public ForgeConfigSpec.ConfigValue<Double> haunted_forest_fog_density;
        public ForgeConfigSpec.ConfigValue<Double> haunted_lakes_fog_density;
        public ForgeConfigSpec.ConfigValue<Double> eroded_haunted_forest_fog_density;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.push("Structure Generation");
            this.large_birch_tree = builder.comment("Enable Large Birch Tree Structure:").translation("graveyard:config:large_birch_tree").worldRestart().define("large_birch_tree", true);
            this.large_birch_tree_separation = builder.comment("Large Birch Tree Separation:").translation("graveyard:config:large_birch_tree_separation").worldRestart().define("large_birch_tree_separation", (Object)12);
            this.large_birch_tree_spacing = builder.comment("Large Birch Tree Spacing:").translation("graveyard:config:large_birch_tree_spacing").worldRestart().define("large_birch_tree_spacing", (Object)14);
            this.large_birch_tree_salt = builder.comment("Large Birch Tree Salt:").translation("graveyard:config:large_birch_tree_salt").worldRestart().define("large_birch_tree_salt", (Object)304812394);
            this.medium_walled_graveyard = builder.comment("Enable Medium Graveyard Structure:").translation("graveyard:config:medium_walled_graveyard").worldRestart().define("medium_walled_graveyard", true);
            this.medium_walled_graveyard_separation = builder.comment("Medium Graveyard Separation:").translation("graveyard:config:medium_walled_graveyard_separation").worldRestart().define("medium_walled_graveyard_separation", (Object)14);
            this.medium_walled_graveyard_spacing = builder.comment("Medium Graveyard Spacing:").translation("graveyard:config:medium_walled_graveyard_spacing").worldRestart().define("medium_walled_graveyard_spacing", (Object)16);
            this.medium_walled_graveyard_salt = builder.comment("Medium Graveyard Salt:").translation("graveyard:config:medium_walled_graveyard_salt").worldRestart().define("medium_walled_graveyard_salt", (Object)379123039);
            this.large_walled_graveyard = builder.comment("Enable Large Graveyard Structure:").translation("graveyard:config:large_walled_graveyard").worldRestart().define("large_walled_graveyard", true);
            this.large_walled_graveyard_separation = builder.comment("Large Graveyard Separation:").translation("graveyard:config:large_walled_graveyard_separation").worldRestart().define("large_walled_graveyard_separation", (Object)9);
            this.large_walled_graveyard_spacing = builder.comment("Large Graveyard Spacing:").translation("graveyard:config:large_walled_graveyard_spacing").worldRestart().define("large_walled_graveyard_spacing", (Object)11);
            this.large_walled_graveyard_salt = builder.comment("Large Graveyard Salt:").translation("graveyard:config:large_walled_graveyard_salt").worldRestart().define("large_walled_graveyard_salt", (Object)739017628);
            this.small_walled_graveyard = builder.comment("Enable Small Graveyard Structure:").translation("graveyard:config:small_walled_graveyard").worldRestart().define("small_walled_graveyard", true);
            this.small_walled_graveyard_separation = builder.comment("Small Graveyard Separation:").translation("graveyard:config:small_walled_graveyard_separation").worldRestart().define("small_walled_graveyard_separation", (Object)18);
            this.small_walled_graveyard_spacing = builder.comment("Small Graveyard Spacing:").translation("graveyard:config:small_walled_graveyard_spacing").worldRestart().define("small_walled_graveyard_spacing", (Object)20);
            this.small_walled_graveyard_salt = builder.comment("Small Graveyard Salt:").translation("graveyard:config:small_walled_graveyard_salt").worldRestart().define("small_walled_graveyard_salt", (Object)1690192399);
            this.small_walled_graveyard_desert = builder.comment("Enable Small Graveyard Desert Structure:").translation("graveyard:config:small_walled_graveyard_desert").worldRestart().define("small_walled_graveyard_desert", true);
            this.small_walled_graveyard_desert_separation = builder.comment("Small Graveyard Desert Separation:").translation("graveyard:config:small_walled_graveyard_desert_separation").worldRestart().define("small_walled_graveyard_desert_separation", (Object)28);
            this.small_walled_graveyard_desert_spacing = builder.comment("Small Graveyard Desert Spacing:").translation("graveyard:config:small_walled_graveyard_desert_spacing").worldRestart().define("small_walled_graveyard_desert_spacing", (Object)32);
            this.small_walled_graveyard_desert_salt = builder.comment("Small Graveyard Desert Salt:").translation("graveyard:config:small_walled_graveyard_desert_salt").worldRestart().define("small_walled_graveyard_desert_salt", (Object)661903018);
            this.small_walled_graveyard_savanna = builder.comment("Enable Small Graveyard Savanna Structure:").translation("graveyard:config:small_walled_graveyard_savanna").worldRestart().define("small_walled_graveyard_savanna", true);
            this.small_walled_graveyard_savanna_separation = builder.comment("Small Graveyard Savanna Separation:").translation("graveyard:config:small_walled_graveyard_savanna_separation").worldRestart().define("small_walled_graveyard_savanna_separation", (Object)12);
            this.small_walled_graveyard_savanna_spacing = builder.comment("Small Graveyard Savanna Spacing:").translation("graveyard:config:small_walled_graveyard_savanna_spacing").worldRestart().define("small_walled_graveyard_savanna_spacing", (Object)14);
            this.small_walled_graveyard_savanna_salt = builder.comment("Small Graveyard Savanna Salt:").translation("graveyard:config:small_walled_graveyard_savanna_salt").worldRestart().define("small_walled_graveyard_savanna_salt", (Object)451235912);
            this.small_grave = builder.comment("Enable Small Grave Structure:").translation("graveyard:config:small_grave").worldRestart().define("small_grave", true);
            this.small_grave_separation = builder.comment("Small Grave Separation:").translation("graveyard:config:small_grave_separation").worldRestart().define("small_grave_separation", (Object)8);
            this.small_grave_spacing = builder.comment("Small Grave Spacing:").translation("graveyard:config:small_grave_spacing").worldRestart().define("small_grave_spacing", (Object)12);
            this.small_grave_salt = builder.comment("Small Grave Salt:").translation("graveyard:config:small_grave_salt").worldRestart().define("small_grave_salt", (Object)240451934);
            this.small_desert_grave = builder.comment("Enable Small Desert Grave Structure:").translation("graveyard:config:small_desert_grave").worldRestart().define("small_desert_grave", true);
            this.small_desert_grave_separation = builder.comment("Small Desert Grave Separation:").translation("graveyard:config:small_desert_grave_separation").worldRestart().define("small_desert_grave_separation", (Object)20);
            this.small_desert_grave_spacing = builder.comment("Small Desert Grave Spacing:").translation("graveyard:config:small_desert_grave_spacing").worldRestart().define("small_desert_grave_spacing", (Object)22);
            this.small_desert_grave_salt = builder.comment("Small Desert Grave Salt:").translation("graveyard:config:small_desert_grave_salt").worldRestart().define("small_desert_grave_salt", (Object)240451934);
            this.small_savanna_grave = builder.comment("Enable Small Savanna Grave Structure:").translation("graveyard:config:small_savanna_grave").worldRestart().define("small_savanna_grave", true);
            this.small_savanna_grave_separation = builder.comment("Small Savanna Grave Separation:").translation("graveyard:config:small_savanna_grave_separation").worldRestart().define("small_savanna_grave_separation", (Object)20);
            this.small_savanna_grave_spacing = builder.comment("Small Savanna Grave Spacing:").translation("graveyard:config:small_savanna_grave_spacing").worldRestart().define("small_savanna_grave_spacing", (Object)22);
            this.small_savanna_grave_salt = builder.comment("Small Savanna Grave Salt:").translation("graveyard:config:small_savanna_grave_salt").worldRestart().define("small_savanna_grave_salt", (Object)240451934);
            this.small_mountain_grave = builder.comment("Enable Small Mountain Grave Structure:").translation("graveyard:config:small_mountain_grave").worldRestart().define("small_mountain_grave", true);
            this.small_mountain_grave_separation = builder.comment("Small Mountain Grave Separation:").translation("graveyard:config:small_mountain_grave_separation").worldRestart().define("small_mountain_grave_separation", (Object)8);
            this.small_mountain_grave_spacing = builder.comment("Small Mountain Grave Spacing:").translation("graveyard:config:small_mountain_grave_spacing").worldRestart().define("small_mountain_grave_spacing", (Object)12);
            this.small_mountain_grave_salt = builder.comment("Small Mountain Grave Salt:").translation("graveyard:config:small_mountain_grave_salt").worldRestart().define("small_mountain_grave_salt", (Object)240451934);
            this.mushroom_grave = builder.comment("Enable Mushroom Grave Structure:").translation("graveyard:config:mushroom_grave").worldRestart().define("mushroom_grave", true);
            this.mushroom_grave_separation = builder.comment("Mushroom Grave Separation:").translation("graveyard:config:mushroom_grave_separation").worldRestart().define("mushroom_grave_separation", (Object)18);
            this.mushroom_grave_spacing = builder.comment("Mushroom Grave Spacing:").translation("graveyard:config:mushroom_grave_spacing").worldRestart().define("mushroom_grave_spacing", (Object)24);
            this.mushroom_grave_salt = builder.comment("Mushroom Grave Salt:").translation("graveyard:config:mushroom_grave_salt").worldRestart().define("mushroom_grave_salt", (Object)598017285);
            this.haunted_house = builder.comment("Enable Haunted House Structure:").translation("graveyard:config:haunted_house").worldRestart().define("haunted_house", true);
            this.haunted_house_separation = builder.comment("Haunted House Separation:").translation("graveyard:config:haunted_house_separation").worldRestart().define("haunted_house_separation", (Object)20);
            this.haunted_house_spacing = builder.comment("Haunted House Spacing:").translation("graveyard:config:haunted_house_spacing").worldRestart().define("haunted_house_spacing", (Object)25);
            this.haunted_house_salt = builder.comment("Haunted House Salt:").translation("graveyard:config:haunted_house_salt").worldRestart().define("haunted_house_salt", (Object)529239621);
            builder.pop();
            builder.push("World Generation");
            HAUNTED_FOREST.apply(builder);
            HAUNTED_LAKES.apply(builder);
            ERODED_HAUNTED_FOREST.apply(builder);
            builder.pop();
            builder.push("Fog Generation in Graveyards");
            this.fog_particle = builder.comment("Enable fog rising from moss in graveyards").translation("graveyard.config.fog_particle").worldRestart().define("fog_particle", true);
            this.fog_particle_chance = builder.comment("Particle chance 1 in ...:").translation("graveyard:config:fog_particle_chance").worldRestart().define("fog_particle_chance", (Object)50);
            builder.pop();
            builder.push("Fog Generation in Biomes");
            this.haunted_forest_fog = builder.comment("Enable fog in Haunted Forest biome").translation("graveyard.config.haunted_forest_fog").worldRestart().define("haunted_forest_fog", true);
            this.haunted_forest_fogMaxY = builder.translation("graveyard:config:haunted_forest_fogMaxY").worldRestart().define("haunted_forest_fogMaxY", (Object)256);
            this.haunted_forest_fogMinY = builder.translation("graveyard:config:haunted_forest_fogMinY").worldRestart().define("haunted_forest_fogMinY", (Object)62);
            this.haunted_forest_fog_density = builder.comment("Fog densitiy").translation("graveyard:config:haunted_forest_fog_density").worldRestart().define("haunted_forest_fog_density", (Object)0.02);
            this.haunted_lakes_fog = builder.comment("Enable fog in Haunted Lakes biome").translation("graveyard.config.haunted_lakes_fog").worldRestart().define("haunted_lakes_fog", true);
            this.haunted_lakes_fogMaxY = builder.translation("graveyard:config:haunted_lakes_fogMaxY").worldRestart().define("haunted_lakes_fogMaxY", (Object)256);
            this.haunted_lakes_fogMinY = builder.translation("graveyard:config:haunted_lakes_fogMinY").worldRestart().define("haunted_lakes_fogMinY", (Object)62);
            this.haunted_lakes_fog_density = builder.comment("Fog densitiy").translation("graveyard:config:haunted_lakes_fog_density").worldRestart().define("haunted_lakes_fog_density", (Object)0.015);
            this.eroded_haunted_forest_fog = builder.comment("Enable fog in Eroded Haunted Forest biome").translation("graveyard.config.eroded_haunted_forest_fog").worldRestart().define("eroded_haunted_forest_fog", true);
            this.eroded_haunted_forest_fogMaxY = builder.translation("graveyard:config:eroded_haunted_forest_fogMaxY").worldRestart().define("eroded_haunted_forest_fogMaxY", (Object)256);
            this.eroded_haunted_forest_fogMinY = builder.translation("graveyard:config:eroded_haunted_forest_fogMinY").worldRestart().define("eroded_haunted_forest_fogMinY", (Object)62);
            this.eroded_haunted_forest_fog_density = builder.comment("Fog densitiy").translation("graveyard:config:eroded_haunted_forest_fog_density").worldRestart().define("eroded_haunted_forest_fog_density", (Object)0.01);
            builder.pop();
        }
    }
}

